require "prefabutil"

local assets=
{
	 Asset("ANIM", "anim/tujian.zip"),
	  Asset("ANIM", "anim/ui_tujian_3x3.zip"),
	  Asset("SOUND", "sound/wx78.fsb"),
}
local function pickupfn(inst, guy)
	if guy.components and guy.components.inventory then
		local potitem = SpawnPrefab("ast")
		guy.components.inventory:GiveItem(potitem)
		inst:Remove()
		return true
	end
end
local function onopen(inst) 	
    inst.AnimState:PlayAnimation("open")
	inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/charged", "overcharge_sound")
end 

local function onclose(inst) 
	inst.AnimState:PlayAnimation("closed")
	inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/charged", "overcharge_sound")
end 

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	inst.components.container:DropEverything()
	inst:Remove()
end



local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("closed")	
end

local function fn()
	local inst = CreateEntity()

    inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()

    MakeObstaclePhysics(inst, .5)  
	


    if not TheWorld.ismastersim then
    return inst
    end

    inst.entity:SetPristine()	

    inst.AnimState:SetBank("tujian")
    inst.AnimState:SetBuild("tujian")
    inst.AnimState:PlayAnimation("closed", true)
    
    inst:AddComponent("inspectable")

    inst:AddComponent("container")
    inst.components.container:WidgetSetup("tujian")    
    inst.components.container.onopenfn = onopen
    inst.components.container.onclosefn = onclose
	inst.components.container.PutOneOfActiveItemInSlot = function(...) end
	inst.components.container.PutAllOfActiveItemInSlot = function(...) end
	inst.components.container.TakeActiveItemFromHalfOfSlot = function(...) end
	inst.components.container.TakeActiveItemFromAllOfSlot = function(...) end
	inst.components.container.AddOneOfActiveItemToSlot = function(...) end
	inst.components.container.AddAllOfActiveItemToSlot = function(...) end
	inst.components.container.SwapActiveItemWithSlot = function(...) end
	inst.components.container.MoveItemFromAllOfSlot = function(...) end
	inst.components.container.MoveItemFromHalfOfSlot = function(...) end
	inst.components.container.ReferenceAllItems = function(...) end
    inst:AddComponent("lootdropper")
	inst:AddComponent("inventoryitem")
	inst:RemoveComponent("inventoryitem")
	local function turnon(inst)
    inst.components.machine.ison = true
	inst.AnimState:PushAnimation("closed")	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem:SetOnPickupFn(pickupfn)
end
local function turnoff(inst)
    inst.components.machine.ison = false
    inst:RemoveComponent("inventoryitem")
	
end
    inst:AddComponent("machine")
    inst.components.machine.turnonfn = turnon
    inst.components.machine.turnofffn = turnoff


    return inst
end

return Prefab( "tujian", fn, assets)

